function design = ATLI_2BL_1d(n, d, ATLI_2BL)
%ATLI_2BL: Generates a 1D ATLI_2BL ARRAY.
%Syntax:
%   design = ATLI_2BL_1d(number_of_sensors, wavelength/2, 'Name');
%Inputs:
%   n - Number of sensors.
%   d - Inter-element spacing.
%   name - Name of the array.
%Outputs:
%   design - An array design struct.
if n <= 9
    error('Sensor amount must larger than 9.');
end
% ========= array configuration ============
% ========= decide spacing
sn_1 = 2;
n_1 = floor((n+2)/6);
n_3 = n_1-1;
n_5 = n_3;
sn_4 = 4 * n_1 ;
sn_3 = 2 * n_1 - 1;
sn_5 = 2 * n_1 + 1;
sn_2 = 2;
n_2 = 2;
sn_6 = 2;
n_6 = n_1;
n_4 = n - 4*n_1;

interspace_12 = 1;
i_2 = sn_1 * (n_1-1) + interspace_12;
 
interspace_23 = (n_1-1)*2-1;
i_3 = i_2 + (n_2-1)*sn_2 + interspace_23 ;
 
interspace_34 = sn_3 ;
i_4 = i_3 + (n_3-1)*sn_3 + interspace_34;
 
interspace_45 = sn_5;
i_5 = i_4 + (n_4-1)*sn_4 + interspace_45;
 
interspace_56 = 2*n_1 + 1;
i_6 = i_5 + (n_5-1)*sn_5 + interspace_56;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sub1 = [];
for sub1_count = 1:n_1
    sub1(sub1_count) = 0 + (sub1_count-1)*sn_1;
end

sub2 = [];
for sub2_count = 1:n_2
    sub2(sub2_count) = 0 + (sub2_count-1)*sn_2;
end
sub2 = sub2+i_2;
sub3 = [];
for sub3_count = 1:n_3
    sub3(sub3_count) = 0 + (sub3_count-1)*sn_3;
end
sub3 = sub3+i_3;
%%%%%%%%%%%%%%%%%%%%%%%%%
sub4 = [];
for sub4_count = 1:n_4
    sub4(sub4_count) = 0 + (sub4_count-1)*sn_4;
end
sub4 = sub4+i_4;
%%%%%%%%%%%%%%%%%%%%%%%%%%
sub5 = [];
for sub5_count = 1:n_5
    sub5(sub5_count) = 0 + (sub5_count-1)*sn_5;
end
sub5 = sub5+i_5;
%%%%%%%%%%%%%%%%%%%%%%%%%%
sub6 = [];
for sub6_count = 1:n_6
    sub6(sub6_count) = 0 + (sub6_count-1)*sn_6;
end
sub6 = sub6+i_6;
%%%%%%%%%%%%%%%%%%%%%%%%%%

if nargin <= 2
    name = sprintf('ATLI-2BL %d sensors', n);
end
design.element_indices = [sub1 sub2 sub3 sub4 sub5 sub6];
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.dim = 1;
design.type = 'ATLI-2BL';
design.name = name;
end